// 文件路径：ruoyi-system/src/main/java/com/ruoyi/dealer/service/impl/DealerRoundResultServiceImpl.java
package com.ruoyi.dealer.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ZipUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.constant.Constants;
import com.ruoyi.common.utils.NumberUtil;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.dealer.domain.DealerBaseInfo;
import com.ruoyi.dealer.domain.DealerResult;
import com.ruoyi.dealer.domain.DealerRoundResult;
import com.ruoyi.dealer.domain.dto.*;
import com.ruoyi.dealer.domain.dto.DealerRoundInfo;
import com.ruoyi.dealer.mapper.DealerRoundResultMapper;
import com.ruoyi.dealer.service.DealerRoundInfoService;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import com.ruoyi.dealer.service.IDealerResultService;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import com.ruoyi.system.service.ISysConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 经销商轮次结果 Service 实现类
 */
@Service
public class DealerRoundResultServiceImpl extends ServiceImpl<DealerRoundResultMapper, DealerRoundResult> implements IDealerRoundResultService {
    @Autowired
    private IDealerBaseInfoService dealerBaseInfoService;
    @Autowired
    private IDealerResultService resultService;
    @Autowired
    private DealerRoundInfoService  roundInfoService;
    @Autowired
    private ISysConfigService configService;

    /**
     * 大屏 个人分组查询
     * 大屏个人分组接口--右侧 鲲鹏组 青龙组 麒麟组
     *
     * @param CategoryName
     * @return
     */
    @Override
    public List<DealerBigScreenGroupListRes> groupList(String CategoryName) {
        // 查询第一列分组的前几名
        List<DealerRoundResult> resultList = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getDealerCategory, CategoryName)
                .eq(DealerRoundResult::getRoundTime, 1)
                .orderByDesc(DealerRoundResult::getPaymentPercentage, DealerRoundResult::getPaymentTtl)
        );

        List<DealerBigScreenGroupListRes> list = new ArrayList<>();
        resultList.forEach(item -> {
            DealerBigScreenGroupListRes res = new DealerBigScreenGroupListRes();
            res.setDealerCategory(item.getDealerCategory());
            res.setDealerName(item.getDealerName());
            res.setDealerId(item.getDealerId());
            res.setPhone(item.getPhone());
            res.setGroupName(item.getGroupName());
            res.setRoundTime(item.getRoundTime());
            res.setGoalTtlAct(item.getGoalTtlAct());
            res.setPaymentTtl(item.getPaymentTtl());
//            res.setPaymentPercentage(getPercentage(item.getPaymentTtl(), item.getGoalTtlAct(), 2) + "%");
            res.setPaymentPercentage(NumberUtil.formatNumber(item.getPaymentPercentage(),2) + "%");
            list.add(res);
        });

        return list;
    }

    @Override
    public List<DealerBigScreenGroupResultRes> groupBySalesRegionGroupTotalList() {
        List<DealerBigScreenGroupResultDto> dealerBigScreenGroupResultRes = this.getBaseMapper().groupTotalList();
        List<DealerBigScreenGroupResultRes> list = new ArrayList<>();
        dealerBigScreenGroupResultRes.forEach(item -> {
            DealerBigScreenGroupResultRes res = new DealerBigScreenGroupResultRes();
            res.setRoundTime(item.getRoundTime());
            res.setGroupName(item.getGroupName());
            res.setSalesRegionGroupName(item.getGroupName());
            res.setPaymentTtl(item.getPaymentTtl());
            res.setGoalTtlAct(item.getGoalTtlAct());
//            res.setPaymentPercentage(getPercentage(item.getPaymentTtl(), item.getGoalTtlAct(), 4) + "%");
            res.setPaymentPercentage(NumberUtil.formatNumber(item.getPaymentPercentage(),4) + "%");
            list.add(res);
        });
        return list;
    }


    /**
     *
     * 按照轮次查询轮次结果
     * @param roundTime
     * @param phone
     * @param dealerName
     * @return
     */
    @Override
    public List<DealerRoundDetailListRes> groupRoundList(Integer roundTime, String phone, String dealerName) {
        List<DealerRoundResult> dealerBigScreenGroupResultRes = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, roundTime)
                .like(ObjectUtil.isNotEmpty(phone), DealerRoundResult::getPhone, phone)
                .like(ObjectUtil.isNotEmpty(dealerName), DealerRoundResult::getDealerName, dealerName)
                .orderByDesc(DealerRoundResult::getSalesRegionGroupName, DealerRoundResult::getPaymentPercentage));
        List<DealerRoundDetailListRes> list = new ArrayList<>();
        dealerBigScreenGroupResultRes.forEach(item -> {
            DealerRoundDetailListRes res = new DealerRoundDetailListRes();
            res.setRoundTime(item.getRoundTime());
            res.setGroupName(item.getGroupName());
            res.setSalesRegionGroupName(item.getSalesRegionGroupName());

            res.setDealerCategory(item.getDealerCategory());
            res.setDealerName(item.getDealerName());
            res.setDealerId(item.getDealerId());
            res.setPhone(item.getPhone());
            res.setPaymentTtl(item.getPaymentTtl());
            res.setGoalTtlAct(item.getGoalTtlAct());

//            res.setPaymentPercentage(getPercentage(item.getPaymentTtl(), item.getGoalTtlAct(), 4) + "%");
            res.setPaymentPercentage(NumberUtil.formatNumber(item.getPaymentPercentage(),4) + "%");
            list.add(res);

        });


        return list;
    }

    @Override
    public int initRoundInfo() {
        List<DealerRoundResult> round1Results = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, 1)
        );
        if (round1Results.size() > 0) {
            throw new RuntimeException("轮次数据已存在");
        }

        // 获取所有经销商信息
        List<DealerBaseInfo> baseInfos = dealerBaseInfoService.list();
        List<DealerRoundInfo> items = new ArrayList<>();
        // 生成动态数据
        baseInfos.forEach(baseInfo -> {
            if(baseInfo.getPaymentTtl()>0){
                DealerRoundInfo item = new DealerRoundInfo();
                item.setDealerId(baseInfo.getDealerId());
                item.setDealerName(baseInfo.getDealerName());

                item.setRoundTime(1);
                item.setPaymentTtlNew(baseInfo.getPaymentTtl());

                item.setGoalTtlAct(baseInfo.getGoalTtlAct());

                item.setPaymentTtlPre(baseInfo.getPaymentTtl());
                item.setPaymentPercentage(baseInfo.getPaymentPercentage() );

                item.setPhone(baseInfo.getPhone());
                item.setCreateTime(LocalDateTime.now());

                items.add(item);
            }

        });
        roundInfoService.saveBatch(items);
        // 复制所有数据
        List<DealerRoundResult> roundResults = new ArrayList<>();
        // 先清空id
        baseInfos.forEach(baseInfo -> {
            DealerRoundResult item = new DealerRoundResult();
            item.setRoundTime(1);
            item.setDealerCategory(baseInfo.getDealerCategory());
            item.setGroupName(baseInfo.getGroupName());
            item.setSalesRegionGroupName(baseInfo.getSalesRegionGroupName());

            item.setDealerId(baseInfo.getDealerId());

            item.setDealerName(baseInfo.getDealerName());
            item.setDealerCategory(baseInfo.getDealerCategory());
            item.setPhone(baseInfo.getPhone());
            item.setGoalTtlAct(baseInfo.getGoalTtlAct());
            item.setPaymentTtlPre(baseInfo.getPaymentTtl());
            item.setPaymentTtl(baseInfo.getPaymentTtl());
            item.setPaymentPercentage(baseInfo.getPaymentPercentage());
            roundResults.add(item);
        });
        this.saveOrUpdateBatch(roundResults);
        return baseInfos.size();
    }

    @Override
    public String downloadZip() {
        List<DealerRoundResult> roundResults = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, 1)
        );
        Map<String, List<DealerRoundResult>> map = roundResults.stream().collect(Collectors.groupingBy(DealerRoundResult::getSalesRegionGroupName));
        // 按照key 生成不同的excel文件
        List<String> excelFilePaths = new ArrayList<>();

        // 生成每个分组的 Excel 文件
        for (Map.Entry<String, List<DealerRoundResult>> entry : map.entrySet()) {
            String groupName = entry.getKey();
            List<DealerRoundResult> groupData = entry.getValue();

            ExcelUtil<DealerRoundResult> util = new ExcelUtil<>(DealerRoundResult.class);
            String excelFileName = "分组结果_" + groupName;
            // 创建临时文件
            File excelFile = FileUtil.createTempFile(excelFileName, ".xlsx", true);
            util.init(groupData, "分组结果", groupName, Excel.Type.EXPORT);
            // 导出到excel文件
            util.exportExcelFile(excelFile);

            excelFilePaths.add(excelFile.getAbsolutePath());
        }

        // 生成 ZIP 文件
        File zipFile = FileUtil.createTempFile();
        InputStream[] inputStreams = new InputStream[excelFilePaths.size()];
        for (int i = 0; i < excelFilePaths.size(); i++) {
            inputStreams[i] = FileUtil.getInputStream(excelFilePaths.get(i));
        }
        File zip = ZipUtil.zip(zipFile, excelFilePaths.toArray(new String[0]), inputStreams);// 打包所有 Excel 文件

        // 返回 ZIP 文件路径
        return zip.getAbsolutePath();
    }

    @Override
    public DealerBigScreenTotalResultRes totalResult() {
        DealerBigScreenTotalResultRes res = null;
        DealerResult total = resultService.getOne(new LambdaQueryWrapper<DealerResult>()
                .eq(DealerResult::getSalesRegionGroupName, "total")
        );
        if (ObjectUtil.isNotEmpty(total)) {
            res = new DealerBigScreenTotalResultRes();
            res.setPaymentTtl(total.getPaymentTtl());
            res.setGoalTtlAct(total.getGoalTtlAct());
            res.setPaymentPercentage(new BigDecimal(res.getPaymentTtl())
                    .multiply(new BigDecimal(100))
                    .divide(new BigDecimal(res.getGoalTtlAct()), 2, RoundingMode.HALF_UP)
                    .toPlainString() + "%");

        } else {
            List<DealerBigScreenTotalResultRes> roundResults = this.baseMapper.getTotalResult();
            res = roundResults.get(0);
            res.setPaymentPercentage(new BigDecimal(res.getPaymentTtl())
                    .multiply(new BigDecimal(100))
                    .divide(new BigDecimal(res.getGoalTtlAct()), 2, RoundingMode.HALF_UP)
                    .toPlainString() + "%");
        }
        return res;
    }

    @Override
    public void downloadExcel(HttpServletResponse response, String group) {
        if (group.equals("1")) {
            // 从数据库查询数据
            List<DealerRoundResult> roundResults = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                    .eq(DealerRoundResult::getRoundTime, 1)
            );
            // 导出到excel文件
            ExcelUtil<DealerRoundResult> util = new ExcelUtil<>(DealerRoundResult.class);
            String encodedFileName = null;
            String fileName = DateUtil.format(new Date(), "yyyyMMddHHmmss") + "个人分组明细.xlsx";

            try {
                encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedFileName + "\"");

            util.exportExcel(response, roundResults, "个人分组明细");
        } else {
            List<DealerResult> roundResults = resultService.list();
            // 导出到excel文件
            ExcelUtil<DealerResult> util = new ExcelUtil<>(DealerResult.class);
            String encodedFileName = null;
            String fileName = DateUtil.format(new Date(), "yyyyMMddHHmmss") + "团队汇总.xlsx";
            try {
                encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedFileName + "\"");
            util.exportExcel(response, roundResults, "团队汇总");
        }

    }

    @Override
    public List<DealerBigScreenRewardResultRes> getRewardList(String groupType, Integer ranking, String groupName) {

        if(groupType.equals("大区")){
            //查询结果
            List<DealerBigScreenGroupResultRes> list = this.groupBySalesRegionGroupTotalList();
            // 转换为响应对象
            List<DealerBigScreenRewardResultRes> resList = list.stream().map(item -> {
                DealerBigScreenRewardResultRes res = new DealerBigScreenRewardResultRes();
                res.setRoundTime(1);
                res.setGroupName(item.getSalesRegionGroupName());
                res.setPaymentTtl(item.getPaymentTtl());
                res.setGoalTtlAct(item.getGoalTtlAct());
                res.setPaymentPercentage(NumberUtil.formatNumber(item.getPaymentPercentage(),2)+"%");
                res.setSalesRegionGroupName(item.getSalesRegionGroupName());
                return res;
            }).collect(Collectors.toList());
            return resList;
        } else{
            String categoryName = "A";
            if("鲲鹏组".equals(groupName)){
                categoryName = "A";
            }else if("青龙组".equals(groupName)){
                categoryName = "B";
            }else{
                categoryName = "C";
            }
//            List<DealerBigScreenGroupListRes> dealerBigScreenGroupListRes = new ArrayList<>();

            List<DealerRoundResult> roundResults = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                    .eq(DealerRoundResult::getDealerCategory, categoryName)
                    .eq(DealerRoundResult::getRoundTime, 1)
                    .orderByAsc(DealerRoundResult::getDealerName)
            );
            List<DealerBigScreenRewardResultRes> resList = roundResults.stream().map(item -> {
                DealerBigScreenRewardResultRes res = new DealerBigScreenRewardResultRes();
                res.setGroupName(item.getGroupName());
                res.setRoundTime(item.getRoundTime());

                res.setDealerName(item.getDealerName());
                res.setDealerId(item.getDealerId());

                res.setGroupName(item.getGroupName());
                res.setPaymentTtl(item.getPaymentTtl());
                res.setGoalTtlAct(item.getGoalTtlAct());
//                res.setPaymentPercentage(this.getPercentage(item.getPaymentTtl(), item.getGoalTtlAct(), 2)+"%");
//                res.setPaymentPercentage(item.getPaymentPercentage()+"%");
                res.setPaymentPercentage(NumberUtil.formatNumber(item.getPaymentPercentage(),2)+"%");
                return res;
            }).collect(Collectors.toList());
            return resList;

        }
    }

    @Override
    public DealerBigScreenTotalResultRes quanguoResult() {
        DealerBigScreenTotalResultRes res = null;
        DealerResult total = resultService.getOne(new LambdaQueryWrapper<DealerResult>()
                .eq(DealerResult::getSalesRegionGroupName, "total")
        );
        if (ObjectUtil.isNotEmpty(total)) {
            res = new DealerBigScreenTotalResultRes();
            res.setPaymentTtl(total.getPaymentTtl());
            res.setGoalTtlAct(total.getGoalTtlAct());
            res.setPaymentPercentage(new BigDecimal(res.getPaymentTtl())
                    .multiply(new BigDecimal(100))
                    .divide(new BigDecimal(res.getGoalTtlAct()), 2, RoundingMode.HALF_UP)
                    .toPlainString() + "%");

        } else {
            List<DealerBigScreenTotalResultRes> roundResults = this.baseMapper.getTotalResult();
            res = roundResults.get(0);
            res.setPaymentPercentage(new BigDecimal(res.getPaymentTtl())
                    .multiply(new BigDecimal(100))
                    .divide(new BigDecimal(res.getGoalTtlAct()), 2, RoundingMode.HALF_UP)
                    .toPlainString() + "%");
        }
        String totalWeidao = configService.selectConfigByKeyFromDb(Constants.TOTAL_WEIDAO);
        Integer totalWeidaoInt = Integer.parseInt(totalWeidao);

        String totalQuanguoGoal = configService.selectConfigByKeyFromDb(Constants.TOTAL_QUANGUO_GOAL);
        Integer totalQuanguoGoalInt = Integer.parseInt(totalQuanguoGoal);

        res.setPaymentTtl(res.getPaymentTtl()+totalWeidaoInt);
        res.setGoalTtlAct(totalQuanguoGoalInt);
        res.setPaymentPercentage(getPercentage(res.getPaymentTtl(), res.getGoalTtlAct(), 2)+"%");

        return res;
     }

    private String getPercentage(Integer paymentTtl, Integer goalTtlAct, Integer scale) {
        if (null == paymentTtl || null == goalTtlAct) {
            return "0";
        }
        return new BigDecimal(paymentTtl)
                .multiply(new BigDecimal(100))
                .divide(new BigDecimal(goalTtlAct), scale, RoundingMode.HALF_UP)
                .stripTrailingZeros()
                .toPlainString();
    }
}
