package com.ruoyi.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 处理结果中的百分比计算，处理小数点问题
 */
public class NumberUtil {

    /**
     * 格式化数字字符串：60则返回"60"，其他数字保留两位小数
     * @param numStr 输入的数字字符串（如"69.0112"、"60"、"60.00"）
     * @return 处理后的字符串
     */
    /**
     * 格式化数字字符串：纯整数（无小数点）保持原样，含小数点的格式化为两位小数
     * @param numStr 输入的数字字符串（如"60"、"69.0112"、"60.0"）
     * @return 处理后的字符串
     */
    public static String formatNumber(String numStr, int scale) {
        // 校验输入合法性
        if (numStr == null || numStr.trim().isEmpty()) {
            throw new IllegalArgumentException("输入字符串不能为空");
        }

        // 去除首尾空格，判断是否为纯整数（无小数点）
        String trimmedStr = numStr.trim();
        if (!trimmedStr.contains(".")) {
            // 纯整数（无小数点）：直接返回trim后的字符串
            return trimmedStr;
        }

        // 含小数点的字符串：解析为数字并格式化为两位小数
        try {
            BigDecimal number = new BigDecimal(trimmedStr);
            // 保留两位小数，四舍五入
            BigDecimal formatted = number.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();
            return formatted.toPlainString();
        } catch (NumberFormatException e) {
            throw new IllegalArgumentException("输入不是有效的数字格式：" + numStr, e);
        }
    }
}
