package com.ruoyi.web.controller.dealer;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.dealer.domain.dto.*;
import com.ruoyi.dealer.service.DealerRoundInfoService;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;

/**
 * 经销商信息Controller
 *
 * @author ruoyi
 */
@RestController
@Slf4j
@RequestMapping("/dealer/bigScreen")
public class DealerBigScreenController extends BaseController {
    @Autowired
    private IDealerBaseInfoService dealerBaseInfoService;
    @Autowired
    private DealerRoundInfoService dealerRoundInfoService;
    @Autowired
    private IDealerRoundResultService resultService;

    /**
     * 查询经销商信息参与者动态
     */
    @GetMapping("/dynamic")
    public AjaxResult dynamicList(Integer roundId) {
        List<DealerBigScreenDynamicRes> list = dealerRoundInfoService.dynamicList(roundId);
        return success(list);
    }


    /**
     * 第一列 按照分组 A B C 获取前几名
     * 大屏个人分组接口--右侧 鲲鹏组 青龙组 麒麟组
     *
     * @param CategoryName
     * @return
     */
    @GetMapping("/group/category/{CategoryName}")
    public AjaxResult groupList(@PathVariable("CategoryName") String CategoryName) {
        List<DealerBigScreenGroupListRes> list = resultService.groupList(CategoryName);
        return success(list);
    }


    /**
     * 第二轮 按照分组获取分组合计的
     */
    @GetMapping("/group/region")
    public AjaxResult groupTotalList() {
        List<DealerBigScreenGroupResultRes> list = resultService.groupBySalesRegionGroupTotalList();
        return success(list);
    }


    @GetMapping("/result/reward")
    public AjaxResult getRewardList( String groupType ,Integer ranking,String groupName) {
        List<DealerBigScreenRewardResultRes> list = resultService.getRewardList(groupType,ranking,groupName);
        return success(list);
    }

    /**
     * 后台的按照轮次查询轮次结果
     *
     */
    @GetMapping("/result/round/{roundTime}")
    public AjaxResult groupRoundList(@PathVariable("roundTime") Integer roundTime, String phone, String dealerName) {
        List<DealerRoundDetailListRes> list = resultService.groupRoundList(roundTime, phone, dealerName);
        return success(list);
    }

    @GetMapping("/result/totalResult")
    public AjaxResult totalResult() {
        DealerBigScreenTotalResultRes res = resultService.totalResult();
        return success(res);
    }

    @GetMapping("/result/quanguoResult")
    public AjaxResult quanguoResult() {
        DealerBigScreenTotalResultRes res = resultService.quanguoResult();
        return success(res);
    }


    @GetMapping("/download/zip")
    public void downloadZip(HttpServletResponse response) {
        // 分组导出 写入到多个excel,并合并到zip文件导出
        try {
            String zipFilePath = resultService.downloadZip(); // 调用服务层
            File zipFile = new File(zipFilePath);

            // 设置响应头
            response.setContentType("application/zip");
            String fileName = DateUtil.format(DateUtil.date(), "yyyyMMddHHmmss") + "竞拍分组结果.zip";
            String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedFileName + "\"");

            // 输出 ZIP 文件内容到浏览器
            try (FileInputStream fis = new FileInputStream(zipFile);
                 OutputStream os = response.getOutputStream()) {
                byte[] buffer = new byte[4096];
                int bytesRead;
                while ((bytesRead = fis.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
                os.flush();
            }

            // 清理资源
            FileUtil.del(zipFile); // 删除 ZIP 文件
        } catch (Exception e) {
            log.error("导出 ZIP 失败", e);
            response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
        }


    }
    @GetMapping("/download/excel")
    public void downloadexcle(HttpServletResponse response, String group) {
      resultService.downloadExcel(response,group);

    }


    @Log(title = "模拟添加数据", businessType = BusinessType.UPDATE)
    @PostMapping("/mockAdd")
    public AjaxResult mockAdd(String phone,Integer pamentTllNew) {
        return toAjax(dealerRoundInfoService.mockAdd(phone,pamentTllNew));
    }
}
