// 文件路径：ruoyi-system/src/main/java/com/ruoyi/dealer/mapper/DealerRoundResultMapper.java
package com.ruoyi.dealer.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.dealer.domain.DealerRoundResult;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupResultDto;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupResultRes;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 经销商轮次结果 Mapper 接口
 */
@Mapper
public interface DealerRoundResultMapper extends BaseMapper<DealerRoundResult> {
    /**
     * 查询组内达成率排前四名经销商列表
     * @param categoryName
     */
    @Select("select * from dealer_round_result where dealer_category = #{categoryName} and round_time = 1 " +
            "order by payment_percentage desc limit 4")
    List<DealerBigScreenGroupResultRes> getGroupList(String categoryName);
    @Select("select result.round_time, result.sales_region_group_name as group_Name , sum(result.payment_ttl) as payment_ttl,sum(result.goal_ttl_act) as goal_ttl_act , 100*sum(result.payment_ttl)/sum(result.goal_ttl_act) as payment_percentage from dealer_round_result  result " +
            "group  by round_time ,result.sales_region_group_name order by payment_percentage desc ")
    // 手动指定映射：column（数据库字段）→ property（Java属性）
    @Results({
            @Result(column = "round_time", property = "roundTime"),
            @Result(column = "group_name", property = "groupName"),
            @Result(column = "payment_ttl", property = "paymentTtl"),
            @Result(column = "goal_ttl_act", property = "goalTtlAct"),
            @Result(column = "payment_percentage", property = "paymentPercentage")// 字段名与属性名一致时可省略
    })
    List<DealerBigScreenGroupResultDto> groupTotalList();
    // 若需要自定义 SQL 方法，可在此添加
}
