package com.ruoyi.dealer.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 经销商轮次填写结果
 * 对应表：dealer_round_result
 */
@Data
@TableName("dealer_round_result")
public class DealerRoundResult {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    @Excel(name = "主键id")
    private Long resultId;

    /**
     * 经销商id
     */
    @Excel(name = "经销商标识")
    private Long dealerId;

    /**
     * 经销商名称
     */
    @Excel(name = "经销商名称")
    private String dealerName;

    /**
     * 当前轮次
     */
    @Excel(name = "经销商名称")
    private Integer roundTime;

    /**
     * 增加的预付款万
     */
    @Excel(name = "预付款")
    private Integer paymentTtl;

    /**
     * 增加前预付款
     */
    private Integer paymentTtlPre;

    /**
     * 手机号
     */
    @Excel(name = "手机号")
    private String phone;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
    /**
     * 创建时间
     */
    private LocalDateTime createTime;


    /**
     * 经销商分类
     */
    private String dealerCategory;
    /**
     * 第一轮分组+第二列分组
     * 分组名称
     */
    @Excel(name = "经销商分组")
    private String groupName;
    @Excel(name = "经销商目标")
    private Integer goalTtlAct;
    /**
     * 预付款达成的百分比
     */
    @Excel(name = "经销商达成率")
    private String paymentPercentage;

    private Integer version;

    /**
     * 销售大区分组名称
     * 第二轮分组使用，例如：华东组、华南组、华北一组、华北二组、华中组、西南组、西北组
     *
     */
    @Excel(name = "经销商大区分组")
    private String salesRegionGroupName;


}
