// 文件路径：ruoyi-system/src/main/java/com/ruoyi/dealer/service/impl/DealerRoundResultServiceImpl.java
package com.ruoyi.dealer.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ZipUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.dealer.domain.DealerBaseInfo;
import com.ruoyi.dealer.domain.DealerRoundResult;
import com.ruoyi.dealer.domain.dto.*;
import com.ruoyi.dealer.mapper.DealerRoundResultMapper;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 经销商轮次结果 Service 实现类
 */
@Service
public class DealerRoundResultServiceImpl extends ServiceImpl<DealerRoundResultMapper, DealerRoundResult> implements IDealerRoundResultService {
   @Autowired
    private IDealerBaseInfoService dealerBaseInfoService;

    /**
     * 大屏 个人分组查询
     * 大屏个人分组接口--右侧 鲲鹏组 青龙组 麒麟组
     * @param CategoryName
     * @return
     */
    @Override
    public List<DealerBigScreenGroupListRes> groupList(String CategoryName) {
        // 查询第一列分组的前几名
        List<DealerRoundResult> resultList = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getDealerCategory, CategoryName)
                .eq(DealerRoundResult::getRoundTime, 1)
                .orderByDesc(DealerRoundResult::getPaymentPercentage, DealerRoundResult::getPaymentTtl)
        );

        List<DealerBigScreenGroupListRes> list = new ArrayList<>();
        resultList.forEach(item -> {
            DealerBigScreenGroupListRes res = new DealerBigScreenGroupListRes();
            res.setDealerCategory(item.getDealerCategory());
            res.setDealerName(item.getDealerName());
            res.setDealerId(item.getDealerId());
            res.setPhone(item.getPhone());
            res.setGroupName(item.getGroupName());
            res.setRoundTime(item.getRoundTime());
            res.setGoalTtlAct(item.getGoalTtlAct());
            res.setPaymentTtl(item.getPaymentTtl());

            res.setPaymentPercentage(getPercentage(item.getPaymentTtl(), item.getGoalTtlAct(), 2)+"%");
            list.add(res);
        });

        return list;
    }

    @Override
    public List<DealerBigScreenGroupResultRes> groupTotalList() {
        List<DealerBigScreenGroupResultDto> dealerBigScreenGroupResultRes = this.getBaseMapper().groupTotalList();
        List<DealerBigScreenGroupResultRes> list = new ArrayList<>();
        dealerBigScreenGroupResultRes.forEach(item -> {
            DealerBigScreenGroupResultRes res = new DealerBigScreenGroupResultRes();
            res.setRoundTime(item.getRoundTime());
            res.setGroupName(item.getGroupName());
            res.setSalesRegionGroupName(item.getGroupName());
            res.setPaymentTtl(item.getPaymentTtl());
            res.setGoalTtlAct(item.getGoalTtlAct());

            res.setPaymentPercentage(getPercentage(item.getPaymentTtl(), item.getGoalTtlAct(), 2) + "%");
            list.add(res);
        });
        return list;
    }

    @Override
    public List<DealerRoundDetailListRes> groupRoundList(Integer roundTime, String phone, String dealerName) {
        List<DealerRoundResult> dealerBigScreenGroupResultRes = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, roundTime)
                .like(ObjectUtil.isNotEmpty(phone), DealerRoundResult::getPhone, phone)
                .like(ObjectUtil.isNotEmpty(dealerName), DealerRoundResult::getDealerName, dealerName)
                .orderByDesc(DealerRoundResult::getSalesRegionGroupName, DealerRoundResult::getPaymentPercentage));
        List<DealerRoundDetailListRes> list = new ArrayList<>();
        dealerBigScreenGroupResultRes.forEach(item -> {
            DealerRoundDetailListRes res = new DealerRoundDetailListRes();
            res.setRoundTime(item.getRoundTime());
            res.setGroupName(item.getGroupName());
            res.setSalesRegionGroupName(item.getSalesRegionGroupName());

            res.setDealerCategory(item.getDealerCategory());
            res.setDealerName(item.getDealerName());
            res.setDealerId(item.getDealerId());
            res.setPhone(item.getPhone());
            res.setPaymentTtl(item.getPaymentTtl());
            res.setGoalTtlAct(item.getGoalTtlAct());

            res.setPaymentPercentage(getPercentage(item.getPaymentTtl(), item.getGoalTtlAct(), 4) + "%");
            list.add(res);

        });


        return list;
    }

    @Override
    public int initRoundInfo() {
        List<DealerRoundResult> round1Results = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, 1)
        );
        if(round1Results.size()>0){
            throw new RuntimeException("轮次数据已存在");
        }
        // 获取所有经销商信息
        List<DealerBaseInfo> resultList = dealerBaseInfoService.list();
        // 复制所有数据
        List<DealerRoundResult> roundResults  = new ArrayList<>();
        // 先清空id
        resultList.forEach(baseInfo -> {
            DealerRoundResult item = new DealerRoundResult();
            item.setRoundTime(1);
            item.setDealerCategory(baseInfo.getDealerCategory());
            item.setGroupName(baseInfo.getGroupName());
            item.setSalesRegionGroupName(baseInfo.getSalesRegionGroupName());

            item.setDealerId(baseInfo.getDealerId());

            item.setDealerName(baseInfo.getDealerName());
            item.setDealerCategory(baseInfo.getDealerCategory());
            item.setPhone(baseInfo.getPhone());
            item.setGoalTtlAct(baseInfo.getGoalTtlAct());
            item.setPaymentTtlPre(baseInfo.getPaymentTtl());
            item.setPaymentTtl(baseInfo.getPaymentTtl());
            item.setPaymentPercentage(getPercentage(baseInfo.getPaymentTtl(), baseInfo.getGoalTtlAct(), 2));
            roundResults.add(item);
        });
        this.saveOrUpdateBatch(roundResults);
        return resultList.size();
    }

    @Override
    public String downloadZip() {
        List<DealerRoundResult> roundResults = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, 1)
        );
        Map<String, List<DealerRoundResult>> map = roundResults.stream().collect(Collectors.groupingBy(DealerRoundResult::getSalesRegionGroupName));
        // 按照key 生成不同的excel文件
        List<String> excelFilePaths = new ArrayList<>();

        // 生成每个分组的 Excel 文件
        for (Map.Entry<String, List<DealerRoundResult>> entry : map.entrySet()) {
            String groupName = entry.getKey();
            List<DealerRoundResult> groupData = entry.getValue();

            ExcelUtil<DealerRoundResult> util = new ExcelUtil<>(DealerRoundResult.class);
            String excelFileName = "分组结果_" + groupName + ".xlsx";
            File excelFile = FileUtil.createTempFile(); // 创建临时文件
            util.init(groupData, "分组结果", groupName, Excel.Type.EXPORT);
            util.exportExcelFile(excelFile); // 导出到临时文件

            excelFilePaths.add(excelFile.getAbsolutePath());
        }

        // 生成 ZIP 文件
        File zipFile = FileUtil.createTempFile();
        InputStream[] inputStreams =new InputStream[excelFilePaths.size()];
        File zip = ZipUtil.zip(zipFile, excelFilePaths.toArray(new String[0]), inputStreams);// 打包所有 Excel 文件

        // 返回 ZIP 文件路径
        return zipFile.getAbsolutePath();
    }

    @Override
    public List<DealerBigScreenTotalResultRes> totalResult() {
        return null;
    }

    private String getPercentage(Integer paymentTtl, Integer goalTtlAct,Integer scale) {
        if(null == paymentTtl || null == goalTtlAct){
            return "0";
        }
        return new BigDecimal(paymentTtl)
                .multiply(new BigDecimal(100))
                .divide(new BigDecimal(goalTtlAct),scale, RoundingMode.HALF_UP)
                .stripTrailingZeros()
                .toPlainString();
    }
}
