package com.ruoyi.web.controller.dealer;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.dealer.domain.DealerBaseInfo;
import com.ruoyi.dealer.domain.dto.WechatDealerRoundInfoReq;
import com.ruoyi.dealer.service.DealerRoundInfoService;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 经销商信息Controller
 *
 * @author ruoyi
 */
@RestController
@RequestMapping("/dealer/baseInfo")
public class DealerBaseInfoController extends BaseController {
    @Autowired
    private IDealerBaseInfoService dealerBaseInfoService;
    @Autowired
    private DealerRoundInfoService dealerRoundInfoService;

    /**
     * 查询经销商信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(DealerBaseInfo dealerBaseInfo) {
        startPage();
        List<DealerBaseInfo> list = dealerBaseInfoService.queryList(dealerBaseInfo);
        return getDataTable(list);
    }

    /**
     * 导出经销商信息列表
     */
    @Log(title = "经销商信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(DealerBaseInfo dealerBaseInfo) {
        List<DealerBaseInfo> list = dealerBaseInfoService.queryList(dealerBaseInfo);
        ExcelUtil<DealerBaseInfo> util = new ExcelUtil<DealerBaseInfo>(DealerBaseInfo.class);
        return util.exportExcel(list, "dealerBaseInfo");
    }

    /**
     * 获取经销商当前轮次的详细信息
     */
    @GetMapping(value = "/round")
    public AjaxResult getRoundInfo() {
        Long dealerId = SecurityUtils.getUserId();
        return AjaxResult.success(dealerBaseInfoService.getDealerRoundInfoByDealerId(dealerId));
    }

    /**
     * 新增经销商信息
     */
    @Log(title = "经销商填写预付款信息", businessType = BusinessType.INSERT)
    @PostMapping(value = "/round")
    public AjaxResult addRoundInfo(@Validated @RequestBody WechatDealerRoundInfoReq dealerRoundInfoReq) {
        return toAjax(dealerRoundInfoService.saveRoundInfo(dealerRoundInfoReq));
    }

    /**
     * 修改经销商信息
     */
    @Log(title = "经销商信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody DealerBaseInfo DealerBaseInfo) {
        return toAjax(dealerBaseInfoService.updateById(DealerBaseInfo));
    }

    /**
     * 删除经销商信息
     */
    @Log(title = "经销商信息", businessType = BusinessType.DELETE)
    @DeleteMapping("/{dealerBaseInfoIds}")
    public AjaxResult remove(@PathVariable Long[] dealerBaseInfoIds) {
        return toAjax(dealerBaseInfoService.removeByIds(Arrays.asList(dealerBaseInfoIds)));
    }
}
