package com.ruoyi.dealer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.constant.Constants;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.dealer.domain.DealerBaseInfo;
import com.ruoyi.dealer.domain.DealerRoundResult;
import com.ruoyi.dealer.domain.dto.WechatDealerRoundInfoRes;
import com.ruoyi.dealer.mapper.DealerBaseInfoMapper;
import com.ruoyi.dealer.service.DealerRoundInfoService;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import com.ruoyi.system.service.ISysConfigService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 参数配置 服务层实现
 *
 * @author ruoyi
 */
@Service
public class DealerBaseInfoImpl extends ServiceImpl<DealerBaseInfoMapper, DealerBaseInfo> implements IDealerBaseInfoService {
    @Autowired
    private DealerBaseInfoMapper dealerBaseInfoMapper;
    @Autowired
    private DealerRoundInfoService dealerRoundInfoService;
    @Autowired
    private IDealerRoundResultService resultService;
    @Autowired
    private ISysConfigService configService;

    @Override
    public List<DealerBaseInfo> queryList(DealerBaseInfo sysStudent) {
        // 注意：mybatis-plus lambda 模式不支持 eclipse 的编译器
        // LambdaQueryWrapper<SysStudent> queryWrapper = Wrappers.lambdaQuery();
        // queryWrapper.eq(SysStudent::getStudentName, sysStudent.getStudentName());
        QueryWrapper<DealerBaseInfo> queryWrapper = Wrappers.query();
//        if (StringUtils.isNotEmpty(sysStudent.getStudentName())) {
//            queryWrapper.eq("student_name", sysStudent.getStudentName());
//        }
//        if (StringUtils.isNotNull(sysStudent.getStudentAge())) {
//            queryWrapper.eq("student_age", sysStudent.getStudentAge());
//        }
//        if (StringUtils.isNotEmpty(sysStudent.getStudentHobby())) {
//            queryWrapper.eq("student_hobby", sysStudent.getStudentHobby());
//        }
        return this.list(queryWrapper);
    }

    @Override
    public WechatDealerRoundInfoRes getDealerRoundInfoByDealerId(Long dealerId) {

        String config = configService.selectConfigByKeyFromDb(Constants.DEALER_ROUND);
        Integer round = Integer.parseInt(config);
        if (round <= 0) {
            throw new ServiceException("轮次未开始");
        }

        DealerBaseInfo dealerBaseInfo = this.getById(dealerId);
        if (dealerBaseInfo == null) {
            throw new ServiceException("经销商不存在");
        }
        // 查询当前的轮次
        WechatDealerRoundInfoRes roundInfoRes = new WechatDealerRoundInfoRes();
        BeanUtils.copyProperties(dealerBaseInfo, roundInfoRes);
        roundInfoRes.setPaymentPercentage(Math.round(dealerBaseInfo.getPaymentTtl() * 100.0 / dealerBaseInfo.getGoalTtlAct()) + "%");

        // 轮次
        roundInfoRes.setRoundTime(round);
        // 区分分组信息
//        roundInfoRes.setReward("老铺黄金-葫芦1号吊坠");
        // 查询结果表，如果有值，更新覆盖
        DealerRoundResult result = resultService.getOne(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, round)
                .eq(DealerRoundResult::getDealerId, dealerId));
        if (result != null) {
            roundInfoRes.setPaymentTtl(result.getPaymentTtl());
            roundInfoRes.setPaymentPercentage(Math.round(result.getPaymentTtl() * 100.0 / dealerBaseInfo.getGoalTtlAct()) + "%");
        }
        if (round == 2) {
            roundInfoRes.setGroupName(dealerBaseInfo.getSalesRegionGroupName());
            // 第二轮第一次 查询结果
            if (result == null) {
                // 查询第一轮的结果
                result = resultService.getOne(new LambdaQueryWrapper<DealerRoundResult>()
                        .eq(DealerRoundResult::getRoundTime, 1)
                        .eq(DealerRoundResult::getDealerId, dealerId));
                roundInfoRes.setPaymentTtl(result.getPaymentTtl());
                roundInfoRes.setPaymentPercentage(Math.round(result.getPaymentTtl() * 100.0 / dealerBaseInfo.getGoalTtlAct()) + "%");
            }
        }
        return roundInfoRes;
    }
}
