package com.ruoyi.web.controller.dealer;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.dealer.service.DealerRoundInfoService;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import com.ruoyi.system.domain.SysConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 经销商信息Controller
 *
 * @author ruoyi
 */
@RestController
@RequestMapping("/dealer/round")
public class DealerRoundController extends BaseController {
    @Autowired
    private DealerRoundInfoService dealerRoundInfoService;

    @Autowired
    private IDealerRoundResultService resultService;

    @Log(title = "结束第一轮次或者第二轮次", businessType = BusinessType.INSERT)
    @GetMapping(value = "/end")
    public AjaxResult endRoundInfo() {
        List<SysConfig> sysConfigs = dealerRoundInfoService.endRound();
        return AjaxResult.success(sysConfigs);
    }

    /**
     * 修改经销商信息
     */
    @Log(title = "初始化第二轮数据", businessType = BusinessType.UPDATE)
    @GetMapping("/init")
    public AjaxResult initRoundInfo() {
        return toAjax(resultService.initRoundInfo());
    }

}
