package com.ruoyi.web.controller.dealer;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.dealer.domain.dto.DealerBigScreenDynamicRes;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupListRes;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupResultRes;
import com.ruoyi.dealer.service.DealerRoundInfoService;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 经销商信息Controller
 *
 * @author ruoyi
 */
@RestController
@RequestMapping("/dealer/bigScreen")
public class DealerBigScreenController extends BaseController {
    @Autowired
    private IDealerBaseInfoService dealerBaseInfoService;
    @Autowired
    private DealerRoundInfoService dealerRoundInfoService;
    @Autowired
    private IDealerRoundResultService resultService;

    /**
     * 查询经销商信息参与者动态
     */
    @GetMapping("/dynamic")
    public AjaxResult dynamicList(Integer roundId) {

        List<DealerBigScreenDynamicRes> list = dealerRoundInfoService.dynamicList(roundId);

        return success(list);
    }


    /**
     * 第一列 按照分组 A B C 获取前几名
     * @param CategoryName
     * @return
     */
    @GetMapping("/group/category/{CategoryName}")
    public AjaxResult groupList(@PathVariable("CategoryName") String CategoryName) {

        List<DealerBigScreenGroupListRes> list = resultService.groupList(CategoryName);

        return success(list);
    }


    /**
     * 第二轮 按照分组获取分组合计的
     *
     */
    @GetMapping("/group/region")
    public AjaxResult groupTotalList() {
        List<DealerBigScreenGroupResultRes> list = resultService.groupTotalList();
        return success(list);
    }

    /**
     * 按照轮次查询轮次结果
     *
     */
    @GetMapping("/result/round/{roundTime}")
    public AjaxResult groupRoundList(@PathVariable("roundTime") Integer roundTime) {

        List<DealerBigScreenGroupListRes> list = resultService.groupRoundList(roundTime);

        return success(list);
    }






}
