package com.ruoyi.dealer.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 经销商轮次填写结果
 * 对应表：dealer_round_result
 */
@Data
@TableName("dealer_round_result")
public class DealerRoundResult {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long resultId;

    /**
     * 经销商id
     */
    private Long dealerId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 当前轮次
     */
    private Integer roundTime;

    /**
     * 增加的预付款万
     */
    private Integer paymentTtl;

    /**
     * 增加前预付款
     */
    private Integer paymentTtlPre;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
    /**
     * 创建时间
     */
    private LocalDateTime createTime;


    /**
     * 经销商分类
     */
    private String dealerCategory;
    private String groupName;
    private Integer goalTtlAct;
    private BigDecimal paymentPercentage;

    private Integer version;

}
