package com.ruoyi.common.utils;

/**
 * 脱敏工具类
 *
 * @author ruoyi
 */
public class DesensitizedUtil {
    /**
     * 密码的全部字符都用*代替，比如：******
     *
     * @param password 密码
     * @return 脱敏后的密码
     */
    public static String password(String password) {
        if (StringUtils.isBlank(password)) {
            return StringUtils.EMPTY;
        }
        return StringUtils.repeat('*', password.length());
    }


    public static String dealerNameSentive(String dealerName) {
        if (StringUtils.isBlank(dealerName)) {
            return StringUtils.EMPTY;
        }
        if (dealerName.length() < 7) {
            return dealerName;
        }

        if (dealerName.contains("市")) {
            int indexArea = dealerName.indexOf("市");
            if(indexArea> 4){
                indexArea =4;
            }else{
                indexArea = 4;
            }
            int endIndex = dealerName.indexOf("有限公司");
            if (endIndex > 0) {
                endIndex = dealerName.length() - 5;
            }else{
                endIndex =dealerName.length() - 5;
            }
            dealerName = StringUtils.hide(dealerName, indexArea, endIndex);
        } else {
            // 不包含市，需要初始化 超过三个字的市 一个集合 ，像内蒙古 哈尔滨等
            String[] citys = {"内蒙古", "黑龙江", "吉林", "辽宁", "河北", "河南", "山东", "山西", "陕西", "新疆", "西藏", "甘肃", "宁夏", "青海", "海南"};
            int startIndex = 4;
//            if (StringUtils.containsAny(dealerName, citys)) {
//                // 返回包含的 下标
//                for (String city : citys) {
//                    int indexCity = dealerName.indexOf(city);
//                    if (indexCity > -1) {
//                        startIndex = dealerName.indexOf(indexCity)+1;
//                        break;
//                    }
//                }
//            }
            int endIndex = dealerName.indexOf("有限公司");
            if (endIndex > 0) {
                endIndex = dealerName.length() - 5;
            }else{
                endIndex = 5;
            }
            dealerName = StringUtils.hide(dealerName, startIndex, endIndex);
        }


        return dealerName;
    }

    /**
     * 车牌中间用*代替，如果是错误的车牌，不处理
     *
     * @param carLicense 完整的车牌号
     * @return 脱敏后的车牌
     */
    public static String carLicense(String carLicense) {
        if (StringUtils.isBlank(carLicense)) {
            return StringUtils.EMPTY;
        }
        // 普通车牌
        if (carLicense.length() == 7) {
            carLicense = StringUtils.hide(carLicense, 3, 6);
        } else if (carLicense.length() == 8) {
            // 新能源车牌
            carLicense = StringUtils.hide(carLicense, 3, 7);
        }
        return carLicense;
    }
}
