// 文件路径：ruoyi-system/src/main/java/com/ruoyi/dealer/mapper/DealerRoundResultMapper.java
package com.ruoyi.dealer.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.dealer.domain.DealerRoundResult;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupResultDto;
import com.ruoyi.dealer.domain.dto.DealerBigScreenTotalResultRes;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 经销商轮次结果 Mapper 接口
 */
@Mapper
public interface DealerRoundResultMapper extends BaseMapper<DealerRoundResult> {

    @Select("select result.round_time, result.sales_region_group_name as group_Name , sum(result.payment_ttl) as payment_ttl,sum(result.goal_ttl_act) as goal_ttl_act , 100*sum(result.payment_ttl)/sum(result.goal_ttl_act) as payment_percentage from dealer_round_result  result " +
            "group  by round_time ,result.sales_region_group_name " +
            "order by payment_percentage desc,sum(result.goal_ttl_act) desc ")
    // 手动指定映射：column（数据库字段）→ property（Java属性）
    @Results({
            @Result(column = "round_time", property = "roundTime"),
            @Result(column = "group_name", property = "groupName"),
            @Result(column = "payment_ttl", property = "paymentTtl"),
            @Result(column = "goal_ttl_act", property = "goalTtlAct"),
            @Result(column = "payment_percentage", property = "paymentPercentage")// 字段名与属性名一致时可省略
    })
    List<DealerBigScreenGroupResultDto> groupTotalList();

    @Select("select  sum(result.payment_ttl) as payment_ttl,sum(result.goal_ttl_act) as goal_ttl_act , 100*sum(result.payment_ttl)/sum(result.goal_ttl_act) as payment_percentage from dealer_round_result  result " +
            " order by payment_percentage desc ")
    // 手动指定映射：column（数据库字段）→ property（Java属性）
    @Results({
             @Result(column = "payment_ttl", property = "paymentTtl"),
            @Result(column = "goal_ttl_act", property = "goalTtlAct"),
            @Result(column = "payment_percentage", property = "paymentPercentage")// 字段名与属性名一致时可省略
    })
    List<DealerBigScreenTotalResultRes> getTotalResult();
    // 若需要自定义 SQL 方法，可在此添加
}
