package com.ruoyi.dealer.domain.dto;

import lombok.Data;

/**
 * 小程序页面看到的经销商的数据信息
 */
@Data
public class WechatDealerRoundInfoRes {
    private Integer roundTime;
    /**
     * 销售大区（非空）
     */
    private Long dealerId;
    /**
     * 销售大区（非空）
     */
    private String salesRegion;

    /**
     * 销售战区（非空）
     */
    private String salesTheater;

    /**
     * 经销商名称（非空）
     * 脱敏经销商名称
     */
    private String dealerName;

    /**
     * 经销商类型
     */
    private String dealerType;



    /**
     * 活动目标TTL
     */
    private Integer goalTtlAct;


    /**
     * 经销商分类
     */
    private String dealerCategory;

    /**
     * 预付款TTL
     */
    private Integer paymentTtl;


    /**
     * 预付款百分比（%）
     */
    private String paymentPercentage;
    /**
     * 脱敏手机号
     */
    private String phone;

    /**
     * 分组名称-按照目标分组 A 麒麟组  B 青龙组  C 鲲鹏组
     * 第二列 销售大区分组名称
     */
    private String groupName;
    /**
     * 销售大区分组名称
     */
    private String salesRegionGroupName;
}
